/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.util.climate.ITemperatureBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;

@ParametersAreNonnullByDefault
public class BlockIceTFC
extends BlockIce
implements ITemperatureBlock {
    private final Fluid waterFluid;
    private final float meltThreshold;

    public BlockIceTFC(Fluid waterFluid) {
        this.waterFluid = waterFluid;
        this.meltThreshold = waterFluid == FluidsTFC.SALT_WATER.get() ? -4.0f : 0.0f;
        this.func_149711_c(0.5f);
        this.func_149713_g(3);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149675_a(true);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.func_180643_i(state));
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                BlockIceTFC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is);
            }
        } else {
            if (worldIn.field_73011_w.func_177500_n()) {
                worldIn.func_175698_g(pos);
                return;
            }
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.harvesters.set(player);
            this.func_176226_b(worldIn, pos, state, enchantmentLevel);
            this.harvesters.set(null);
            Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) {
                worldIn.func_175656_a(pos, this.waterFluid.getBlock().func_176223_P());
            }
        }
    }

    protected void func_185679_b(World worldIn, BlockPos pos) {
        if (worldIn.field_73011_w.func_177500_n()) {
            worldIn.func_175698_g(pos);
        } else {
            this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
            worldIn.func_175656_a(pos, this.waterFluid.getBlock().func_176223_P());
            worldIn.func_190524_a(pos, this.waterFluid.getBlock(), pos);
        }
    }

    @Override
    public void onTemperatureUpdateTick(World world, BlockPos pos, IBlockState state) {
        if (world.func_175642_b(EnumSkyBlock.BLOCK, pos) > 11 - this.getLightOpacity(state, (IBlockAccess)world, pos) || ClimateTFC.getActualTemp(world, pos) > this.meltThreshold) {
            this.func_185679_b(world, pos);
        }
    }
}

